/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io;

import java.util.Locale;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.io.FilenameUtils;

public final class FileSystem
extends Enum<FileSystem> {
    public static final /* enum */ FileSystem GENERIC = new FileSystem(4096, false, false, Integer.MAX_VALUE, Integer.MAX_VALUE, new int[]{0}, new String[0], false, false, '/');
    public static final /* enum */ FileSystem LINUX = new FileSystem(8192, true, true, 255, 4096, new int[]{0, 47}, new String[0], false, false, '/');
    public static final /* enum */ FileSystem MAC_OSX = new FileSystem(4096, true, true, 255, 1024, new int[]{0, 47, 58}, new String[0], false, false, '/');
    public static final /* enum */ FileSystem WINDOWS = new FileSystem(4096, false, true, 255, 32000, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 47, 58, 60, 62, 63, 92, 124}, new String[]{"AUX", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "COM\u00b2", "COM\u00b3", "COM\u00b9", "CON", "CONIN$", "CONOUT$", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "LPT\u00b2", "LPT\u00b3", "LPT\u00b9", "NUL", "PRN"}, true, true, '\\');
    private static final boolean IS_OS_LINUX;
    private static final boolean IS_OS_MAC;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    private static final boolean IS_OS_WINDOWS;
    private static final FileSystem CURRENT;
    private final int blockSize;
    private final boolean casePreserving;
    private final boolean caseSensitive;
    private final int[] illegalFileNameChars;
    private final int maxFileNameLength;
    private final int maxPathLength;
    private final String[] reservedFileNames;
    private final boolean reservedFileNamesExtensions;
    private final boolean supportsDriveLetter;
    private final char nameSeparator;
    private final char nameSeparatorOther;
    private static final /* synthetic */ FileSystem[] $VALUES;

    public static FileSystem[] values() {
        return (FileSystem[])$VALUES.clone();
    }

    private static FileSystem current() {
        if (IS_OS_LINUX) {
            return LINUX;
        }
        if (IS_OS_MAC) {
            return MAC_OSX;
        }
        if (IS_OS_WINDOWS) {
            return WINDOWS;
        }
        return GENERIC;
    }

    public static FileSystem getCurrent() {
        return CURRENT;
    }

    private static boolean getOsMatchesName(String osNamePrefix) {
        return FileSystem.isOsNameMatch(FileSystem.getSystemProperty("os.name"), osNamePrefix);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    private static boolean isOsNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.toUpperCase(Locale.ROOT).startsWith(osNamePrefix.toUpperCase(Locale.ROOT));
    }

    private FileSystem(int blockSize, boolean caseSensitive, boolean casePreserving, int maxFileLength, int maxPathLength, int[] illegalFileNameChars, String[] reservedFileNames, boolean reservedFileNamesExtensions, boolean supportsDriveLetter, char nameSeparator) {
        this.blockSize = blockSize;
        this.maxFileNameLength = maxFileLength;
        this.maxPathLength = maxPathLength;
        this.illegalFileNameChars = Objects.requireNonNull(illegalFileNameChars, "illegalFileNameChars");
        this.reservedFileNames = Objects.requireNonNull(reservedFileNames, "reservedFileNames");
        this.reservedFileNamesExtensions = reservedFileNamesExtensions;
        this.caseSensitive = caseSensitive;
        this.casePreserving = casePreserving;
        this.supportsDriveLetter = supportsDriveLetter;
        this.nameSeparator = nameSeparator;
        this.nameSeparatorOther = FilenameUtils.flipSeparator(nameSeparator);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private static /* synthetic */ FileSystem[] $values() {
        return new FileSystem[]{GENERIC, LINUX, MAC_OSX, WINDOWS};
    }

    static {
        $VALUES = FileSystem.$values();
        IS_OS_LINUX = FileSystem.getOsMatchesName("Linux");
        IS_OS_MAC = FileSystem.getOsMatchesName("Mac");
        IS_OS_WINDOWS = FileSystem.getOsMatchesName(OS_NAME_WINDOWS_PREFIX);
        CURRENT = FileSystem.current();
    }
}

