/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.MetaMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.GeneratedMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureStaticMetaMethod;
import org.codehaus.groovy.runtime.metaclass.MixinInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewMetaMethod;
import org.codehaus.groovy.util.FastArray;

public class MetaMethodIndex {
    private static final int DEFAULT_CAPACITY = 32;
    public final Map<Class<?>, Map<String, Cache>> indexMap = new ConcurrentHashMap(32);
    public final Class<?> mainClass;

    public MetaMethodIndex(CachedClass theCachedClass) {
        this.mainClass = theCachedClass.getTheClass();
        if (!theCachedClass.isInterface()) {
            for (CachedClass c = theCachedClass; c != null; c = c.getCachedSuperClass()) {
                this.indexMap.put(c.getTheClass(), new ConcurrentHashMap());
            }
        } else {
            this.indexMap.put(Object.class, new ConcurrentHashMap());
            this.indexMap.put(this.mainClass, new ConcurrentHashMap());
        }
    }

    public final Cache getMethods(Class<?> cls, String name) {
        Map<String, Cache> map = this.indexMap.get(cls);
        return map == null ? null : map.get(name);
    }

    public void addMetaMethod(MetaMethod method, Map<String, Cache> map) {
        Cache cache = map.computeIfAbsent(method.getName(), Cache::new);
        if (method.isStatic()) {
            cache.staticMethods = this.addMethodToList(cache.staticMethods, method);
        }
        cache.methods = this.addMethodToList(cache.methods, method);
    }

    private Cache getOrPutMethods(String name, Map<String, Cache> cacheIndex) {
        return cacheIndex.computeIfAbsent(name, Cache::new);
    }

    public Map<String, Cache> getHeader(Class<?> cls) {
        return this.indexMap.get(cls);
    }

    public void copyNonPrivateMethods(Map<String, Cache> from, Map<String, Cache> to) {
        for (Cache e : from.values()) {
            this.copyNonPrivateMethods(e, to);
        }
    }

    private void copyNonPrivateMethods(Cache from, Map<String, Cache> to) {
        Object fastArrayOrMetaMethod = from.methods;
        if (fastArrayOrMetaMethod instanceof FastArray) {
            FastArray fastArray = (FastArray)fastArrayOrMetaMethod;
            Cache e = null;
            int n = fastArray.size();
            Object[] array = fastArray.getArray();
            for (int i = 0; i != n; ++i) {
                MetaMethod method = (MetaMethod)array[i];
                if (!this.isNonPrivate(method)) continue;
                if (e == null) {
                    e = this.getOrPutMethods(from.name, to);
                }
                e.methods = this.addMethodToList(e.methods, method);
            }
        } else {
            MetaMethod method = (MetaMethod)fastArrayOrMetaMethod;
            if (this.isNonPrivate(method)) {
                Cache e = this.getOrPutMethods(from.name, to);
                e.methods = this.addMethodToList(e.methods, method);
            }
        }
    }

    public void copyNonPrivateNonNewMetaMethods(Map<String, Cache> from, Map<String, Cache> to) {
        for (Cache e : from.values()) {
            this.copyNonPrivateNonNewMetaMethods(e, to);
        }
    }

    private void copyNonPrivateNonNewMetaMethods(Cache from, Map<String, Cache> to) {
        MetaMethod method;
        Object fastArrayOrMetaMethod = from.methods;
        if (fastArrayOrMetaMethod instanceof FastArray) {
            FastArray fastArray = (FastArray)fastArrayOrMetaMethod;
            Cache e = null;
            int n = fastArray.size();
            Object[] array = fastArray.getArray();
            for (int i = 0; i != n; ++i) {
                MetaMethod method2 = (MetaMethod)array[i];
                if (!this.isNonPrivate(method2) || method2 instanceof NewMetaMethod) continue;
                if (e == null) {
                    e = this.getOrPutMethods(from.name, to);
                }
                e.methods = this.addMethodToList(e.methods, method2);
            }
        } else if (fastArrayOrMetaMethod != null && this.isNonPrivate(method = (MetaMethod)fastArrayOrMetaMethod) && !(method instanceof NewMetaMethod)) {
            Cache e = this.getOrPutMethods(from.name, to);
            e.methods = this.addMethodToList(e.methods, method);
        }
    }

    private boolean isNonPrivate(MetaMethod method) {
        return !method.isPrivate() && (!method.isPackagePrivate() || GeneralUtils.inSamePackage(method.getDeclaringClass().getTheClass(), this.mainClass));
    }

    public Object addMethodToList(Object o, MetaMethod toIndex) {
        if (o == null) {
            return toIndex;
        }
        if (o instanceof MetaMethod) {
            MetaMethod inIndex = (MetaMethod)o;
            if (!MetaMethodIndex.isMatchingMethod(inIndex, toIndex)) {
                return new FastArray(new Object[]{inIndex, toIndex});
            }
            return !MetaMethodIndex.isOverridden(inIndex, toIndex) ? inIndex : toIndex;
        }
        if (o instanceof FastArray) {
            FastArray array = (FastArray)o;
            int found = MetaMethodIndex.findMatchingMethod(array, toIndex);
            if (found == -1) {
                array.add(toIndex);
            } else {
                MetaMethod inIndex = (MetaMethod)array.get(found);
                if (inIndex != toIndex && MetaMethodIndex.isOverridden(inIndex, toIndex)) {
                    array.set(found, toIndex);
                }
            }
        }
        return o;
    }

    private static boolean isOverridden(MetaMethod inIndex, MetaMethod toIndex) {
        CachedClass toIndexDC;
        if (inIndex.isPrivate()) {
            return false;
        }
        CachedClass inIndexDC = inIndex.getDeclaringClass();
        if (inIndexDC == (toIndexDC = toIndex.getDeclaringClass())) {
            return MetaMethodIndex.isNonRealMethod(toIndex) || inIndex.isSynthetic();
        }
        if (!(inIndex.isStatic() || toIndex.isStatic() || inIndexDC.isInterface() == toIndexDC.isInterface() || toIndex instanceof ClosureMetaMethod || toIndex instanceof ClosureStaticMetaMethod)) {
            return (MetaMethodIndex.isNonRealMethod(inIndex) || !inIndexDC.isInterface() || toIndexDC.isInterface()) && !toIndexDC.isAssignableFrom(inIndexDC.getTheClass());
        }
        return inIndexDC.isAssignableFrom(toIndexDC.getTheClass());
    }

    private static boolean isNonRealMethod(MetaMethod method) {
        return method instanceof NewMetaMethod || method instanceof ClosureMetaMethod || method instanceof GeneratedMetaMethod || method instanceof ClosureStaticMetaMethod || method instanceof MixinInstanceMetaMethod || method instanceof ClosureMetaMethod.AnonymousMetaMethod;
    }

    private static boolean isMatchingMethod(MetaMethod method1, MetaMethod method2) {
        CachedClass[] params2;
        if (method1 == method2) {
            return true;
        }
        CachedClass[] params1 = method1.getParameterTypes();
        if (params1.length != (params2 = method2.getParameterTypes()).length) {
            return false;
        }
        int n = params1.length;
        for (int i = 0; i < n; ++i) {
            if (params1[i] == params2[i]) continue;
            return false;
        }
        return true;
    }

    private static int findMatchingMethod(FastArray list, MetaMethod method) {
        int n = list.size();
        Object[] data = list.getArray();
        for (int i = 0; i != n; ++i) {
            MetaMethod aMethod = (MetaMethod)data[i];
            if (!MetaMethodIndex.isMatchingMethod(aMethod, method)) continue;
            return i;
        }
        return -1;
    }

    public void copyMethodsToSuper() {
        this.allEntries().forEach(cacheEntry -> {
            cacheEntry.methodsForSuper = cacheEntry.methods instanceof FastArray ? ((FastArray)cacheEntry.methods).copy() : cacheEntry.methods;
        });
    }

    private Stream<Cache> allEntries() {
        return this.indexMap.values().stream().flatMap(map -> map.values().stream());
    }

    public void clearCaches() {
        this.allEntries().forEach(e -> {
            e.cachedStaticMethod = null;
            e.cachedMethodForSuper = null;
            e.cachedMethod = null;
        });
    }

    public void clearCaches(String name) {
        this.allEntries().filter(cache -> cache.name.equals(name)).forEach(e -> {
            e.cachedStaticMethod = null;
            e.cachedMethodForSuper = null;
            e.cachedMethod = null;
        });
    }

    public static class Cache {
        public final String name;
        public Object methods;
        public Object methodsForSuper;
        public Object staticMethods;
        public MetaMethodCache cachedMethod;
        public MetaMethodCache cachedMethodForSuper;
        public MetaMethodCache cachedStaticMethod;

        public Cache(String name) {
            this.name = name;
        }

        public String toString() {
            return "[name=" + this.name + "]";
        }
    }

    public static class MetaMethodCache {
        public final Class<?>[] params;
        public final MetaMethod method;

        public MetaMethodCache(Class<?>[] params, MetaMethod method) {
            this.params = params;
            this.method = method;
        }
    }
}

