/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.properties;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.actions.HelpAction;
import org.netbeans.jellytools.actions.PropertiesAction;
import org.netbeans.jellytools.actions.ShowDescriptionAreaAction;
import org.netbeans.jellytools.actions.SortByCategoryAction;
import org.netbeans.jellytools.actions.SortByNameAction;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.windows.TopComponent;

public class PropertySheetOperator
extends TopComponentOperator {
    private JTableOperator _tblSheet;
    private JLabelOperator _lblDescriptionHeader;
    private JEditorPaneOperator _txtDescription;
    private JButtonOperator _btHelp;
    public static final int MODE_NO_PROPERTIES = 0;
    public static final int MODE_PROPERTIES_OF_ONE_OBJECT = 1;
    public static final int MODE_PROPERTIES_OF_MULTIPLE_OBJECTS = 2;

    public PropertySheetOperator(JComponent jComponent) {
        super(jComponent);
    }

    public PropertySheetOperator() {
        this(PropertySheetOperator.waitPropertySheet(null, 0));
    }

    public PropertySheetOperator(int n) {
        this(n, "");
    }

    public PropertySheetOperator(int n, String string) {
        this(Bundle.getString("org.netbeans.core.windows.view.ui.Bundle", "CTL_FMT_GlobalProperties", new Object[]{n, string}));
    }

    public PropertySheetOperator(String string) {
        this(PropertySheetOperator.waitPropertySheet(string, 0));
    }

    public PropertySheetOperator(ContainerOperator containerOperator, String string) {
        super((JComponent)containerOperator.waitSubComponent((ComponentChooser)new PropertySheetSubchooser(string, containerOperator.getComparator())));
        this.copyEnvironment((Operator)containerOperator);
    }

    public PropertySheetOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public PropertySheetOperator(ContainerOperator containerOperator, int n) {
        super((JComponent)containerOperator.waitSubComponent((ComponentChooser)new PropertySheetSubchooser(), n));
        this.copyEnvironment((Operator)containerOperator);
    }

    public static PropertySheetOperator invoke() {
        new PropertiesAction().perform();
        return new PropertySheetOperator();
    }

    public JTableOperator tblSheet() {
        if (this._tblSheet == null) {
            this._tblSheet = new JTableOperator((ContainerOperator)this);
        }
        return this._tblSheet;
    }

    public JLabelOperator lblDescriptionHeader() {
        if (this._lblDescriptionHeader == null) {
            this._lblDescriptionHeader = new JLabelOperator((ContainerOperator)this);
        }
        return this._lblDescriptionHeader;
    }

    public JEditorPaneOperator txtDescription() {
        if (this._txtDescription == null) {
            this._txtDescription = new JEditorPaneOperator((ContainerOperator)this);
        }
        return this._txtDescription;
    }

    public JButtonOperator btHelp() {
        if (this._btHelp == null) {
            this._btHelp = new JButtonOperator((ContainerOperator)this);
        }
        return this._btHelp;
    }

    public String getDescriptionHeader() {
        return this.lblDescriptionHeader().getText();
    }

    public String getDescription() {
        return this.txtDescription().getText();
    }

    public void sortByName() {
        new SortByNameAction().perform((ComponentOperator)this);
    }

    public void sortByCategory() {
        new SortByCategoryAction().perform((ComponentOperator)this);
    }

    public void showDescriptionArea() {
        new ShowDescriptionAreaAction().perform((ComponentOperator)this);
    }

    public void help() {
        new HelpAction().performPopup((ComponentOperator)this);
    }

    public void verify() {
        this.tblSheet();
    }

    @Override
    public void close() {
        boolean bl;
        if (this.getSource() instanceof TopComponent && (bl = this.runMapping(new Operator.MapBooleanAction("canClose"){

            public boolean map() {
                return ((TopComponent)PropertySheetOperator.this.getSource()).canClose();
            }
        }))) {
            super.close();
            return;
        }
        if (this.getWindow() != MainWindowOperator.getDefault().getSource()) {
            new WindowOperator(this.getWindow()).requestClose();
        }
    }

    public void clickForPopup() {
        final Component component = this.findSubComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component.getClass().getSimpleName().equals("PSheet");
            }

            public String getDescription() {
                return "org.openide.explorer.propertysheet.PSheet";
            }
        });
        if (component != null) {
            this.runMapping(new Operator.MapVoidAction("mousePressed"){

                public void map() {
                    ((MouseListener)((Object)component)).mousePressed(new MouseEvent(PropertySheetOperator.this.getSource(), 501, System.currentTimeMillis(), 0, PropertySheetOperator.this.getCenterXForClick(), PropertySheetOperator.this.getCenterYForClick(), 1, true));
                }
            });
        } else {
            super.clickForPopup();
        }
    }

    private static JComponent findPropertySheet(String string, int n) {
        JComponent jComponent = PropertySheetOperator.findTopComponent(null, string, n, new PropertySheetSubchooser());
        if (jComponent != null) {
            return jComponent;
        }
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            Window[] windowArray = frameArray[i].getOwnedWindows();
            for (int j = 0; j < windowArray.length; ++j) {
                if (!windowArray[j].isShowing()) continue;
                WindowOperator windowOperator = new WindowOperator(windowArray[j]);
                windowOperator.setOutput(TestOut.getNullOutput());
                jComponent = (JComponent)windowOperator.findSubComponent((ComponentChooser)new PropertySheetSubchooser(string, MainWindowOperator.getDefault().getComparator()), n);
                if (jComponent == null) continue;
                return jComponent;
            }
        }
        return null;
    }

    private static JComponent waitPropertySheet(final String string, final int n) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return PropertySheetOperator.findPropertySheet(string, n);
                }

                public String getDescription() {
                    return "Wait PropertySheet with name=" + string + " index=" + n + " loaded";
                }
            });
            Timeouts timeouts = JemmyProperties.getCurrentTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("ComponentOperator.WaitComponentTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (JComponent)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    private static final class PropertySheetSubchooser
    implements ComponentChooser {
        private String sheetName;
        private Operator.StringComparator comparator;

        public PropertySheetSubchooser() {
        }

        public PropertySheetSubchooser(String string, Operator.StringComparator stringComparator) {
            this.sheetName = string;
            this.comparator = stringComparator;
        }

        public boolean checkComponent(Component component) {
            if (component == null) {
                return false;
            }
            if (component instanceof PropertySheet || component.getClass().getSimpleName().equals("NbSheet")) {
                if (this.sheetName == null) {
                    return true;
                }
                if (component instanceof TopComponent) {
                    String string = ((TopComponent)component).getDisplayName();
                    if (string == null) {
                        string = component.getName();
                    }
                    return this.comparator.equals(string, this.sheetName);
                }
            }
            return false;
        }

        public String getDescription() {
            return "org.openide.explorer.propertysheet.PropertySheet";
        }
    }
}

