/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategy;
import com.oracle.bmc.waiter.MaxTimeTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import jakarta.annotation.Nullable;

public class Waiters {
    public static final DelayStrategy DEFAULT_POLLING_DELAY_STRATEGY = new ExponentialBackoffDelayStrategy(Waiters.secondsToMillis(30));
    public static final TerminationStrategy DEFAULT_POLLING_TERMINATION_STRATEGY = new MaxTimeTerminationStrategy(Waiters.secondsToMillis(1200));
    public static final BmcGenericWaiter DEFAULT_POLLING_WAITER = new BmcGenericWaiter(DEFAULT_POLLING_TERMINATION_STRATEGY, DEFAULT_POLLING_DELAY_STRATEGY);

    public static BmcGenericWaiter newWaiter(@Nullable TerminationStrategy terminationStrategy, @Nullable DelayStrategy delayStrategy) {
        TerminationStrategy terminationStrategyToUse = terminationStrategy != null ? terminationStrategy : DEFAULT_POLLING_TERMINATION_STRATEGY;
        DelayStrategy delayStrategyToUse = delayStrategy != null ? delayStrategy : DEFAULT_POLLING_DELAY_STRATEGY;
        return new BmcGenericWaiter(terminationStrategyToUse, delayStrategyToUse);
    }

    private static long secondsToMillis(int seconds) {
        return (long)seconds * 1000L;
    }
}

